var fs=require("fs");var http=require("http");var os=require("os");var Stream=require("stream");var URL=require("url");var util=require("util");var Lazy=require("./lazy.js");var isHarmonySupported=require("./util.js").isHarmonySupported;if(isHarmonySupported()){require("./experimental/lazy.es6.js")}function StreamedSequence(stream){this.stream=stream}StreamedSequence.prototype=new Lazy.StreamLikeSequence;StreamedSequence.prototype.openStream=function(callback){this.stream.resume();callback(this.stream)};StreamedSequence.prototype.each=function(fn){var cancelled=false,encoding=this.encoding;var handle=new Lazy.AsyncHandle(function cancel(){cancelled=true});this.openStream(function(stream){if(stream.setEncoding){stream.setEncoding(encoding||"utf8")}var listener=function(e){try{if(cancelled||fn(e)===false){stream.removeListener("data",listener);handle._resolve(false)}}catch(e){handle._reject(e)}};stream.on("data",listener);stream.on("end",function(){handle._resolve(true)})});return handle};StreamedSequence.prototype.lines=function(){return this.split(os.EOL||"\n")};function FileStreamSequence(path,encoding){this.path=path;this.encoding=encoding}FileStreamSequence.prototype=new StreamedSequence;FileStreamSequence.prototype.openStream=function(callback){var stream=fs.createReadStream(this.path,{autoClose:true});callback(stream)};Lazy.readFile=function(path,encoding){return new FileStreamSequence(path,encoding)};function HttpStreamSequence(url,encoding){this.url=url;this.encoding=encoding}HttpStreamSequence.prototype=new StreamedSequence;HttpStreamSequence.prototype.openStream=function(callback){http.get(URL.parse(this.url),callback)};Lazy.makeHttpRequest=function(url){return new HttpStreamSequence(url)};if(typeof Stream.Readable!=="undefined"){Lazy.Sequence.prototype.toStream=function toStream(options){return new LazyStream(this,options)};Lazy.Sequence.prototype.pipe=function pipe(destination){this.toStream().pipe(destination)};function LazyStream(sequence,options){options=Lazy(options||{}).extend({objectMode:true}).toObject();Stream.Readable.call(this,options);this.sequence=sequence;this.started=false;while(sequence){if(sequence.delimiter){this.delimiter=sequence.delimiter;break}sequence=sequence.parent}}util.inherits(LazyStream,Stream.Readable);LazyStream.prototype._read=function(){var self=this;if(!this.started){var handle=this.sequence.each(function(line,i){if(self.delimiter!=null){line+=self.delimiter}return self.push(line,i)});if(handle instanceof Lazy.AsyncHandle){handle.onComplete(function(){self.push(null)})}this.started=true}}}Lazy.extensions||(Lazy.extensions=[]);Lazy.extensions.push(function(source){if(source instanceof Stream){return new StreamedSequence(source)}});module.exports=Lazy;