<?php

class PluginFieldsCursofieldDropdown extends CommonTreeDropdown {
   public $field_name      = "cursofield";
   public $can_be_translated = true;

   static function getTypeName($nb=0) {
      $item = [
         "itemtype" => PluginFieldsField::getType(),
         "id"       => "4",
         "label"    => "Curso"
      ];
      $label = PluginFieldsLabelTranslation::getLabelFor($item);
      return $label;
   }

   static function install() {
      global $DB;

      $default_charset = DBConnection::getDefaultCharset();
      $default_collation = DBConnection::getDefaultCollation();
      $default_key_sign = DBConnection::getDefaultPrimaryKeySignOption();

      $obj = new self();
      $table = $obj->getTable();

      if (!$DB->tableExists($table)) {
         $query = "CREATE TABLE IF NOT EXISTS `$table` (
                  `id`                                      INT            {$default_key_sign} NOT NULL auto_increment,
                  `name`                                    VARCHAR(255)   DEFAULT NULL,
                  `completename`                            TEXT           DEFAULT NULL,
                  `comment`                                 TEXT           DEFAULT NULL,
                  `plugin_fields_cursofielddropdowns_id` INT            {$default_key_sign} DEFAULT NULL,
                  `level`                                   INT            DEFAULT NULL,
                  `ancestors_cache`                         TEXT           DEFAULT NULL,
                  `sons_cache`                              TEXT           DEFAULT NULL,
                  `entities_id`                             INT            {$default_key_sign} NOT NULL DEFAULT '0',
                  `is_recursive`                            TINYINT        NOT NULL DEFAULT '0',
                  PRIMARY KEY                               (`id`),
                  KEY                                       `entities_id`  (`entities_id`),
                  KEY                                       `is_recursive` (`is_recursive`),
                  KEY                                       `plugin_fields_cursofielddropdowns_id`
                                                            (`plugin_fields_cursofielddropdowns_id`)
               ) ENGINE=InnoDB DEFAULT CHARSET={$default_charset} COLLATE={$default_collation} ROW_FORMAT=DYNAMIC;";
         $DB->query($query) or die ($DB->error());
      }
   }

   static function uninstall() {
      global $DB;

      $obj = new self();
      return $DB->query("DROP TABLE IF EXISTS `".$obj->getTable()."`");
   }

   /**
    * Get the search page URL for the current classe
    *
    * @param $full path or relative one (true by default)
   **/
   static function getTabsURL($full=true) {
      $url = Toolbox::getItemTypeTabsURL('PluginFieldsCommonDropdown', $full);
      $plug = isPluginItemType(get_called_class());
      $url .= '?ddtype=' . strtolower($plug['class']);
      return $url;
   }

   /**
    * Get the search page URL for the current class
    *
    * @param $full path or relative one (true by default)
   **/
   static function getSearchURL($full=true) {
      $url = Toolbox::getItemTypeSearchURL('PluginFieldsCommonDropdown', $full);
      $plug = isPluginItemType(get_called_class());
      $url .= '?ddtype=' . strtolower($plug['class']);
      return $url;
   }

   /**
    * Get the form page URL for the current class
    *
    * @param $full path or relative one (true by default)
   **/
   static function getFormURL($full=true) {
      $url = Toolbox::getItemTypeFormURL('PluginFieldsCommonDropdown', $full);
      $plug = isPluginItemType(get_called_class());
      $url .= '?ddtype=' . strtolower($plug['class']);
      return $url;
   }

   /**
    * Get the form page URL for the current class and point to a specific ID
    *
    * @param $id      (default 0)
    * @param $full    path or relative one (true by default)
    *
    * @since version 0.90
   **/
   static function getFormURLWithID($id=0, $full=true) {

      $link     = self::getFormURL($full);
      $link    .= '&id=' . $id;
      return $link;
   }

   /**
    * Get default values to search engine to override
   **/
   static function getDefaultSearchRequest() {
      $plug = isPluginItemType(get_called_class());
      $search = ['addhidden' => ['ddtype' => strtolower($plug['class'])]];
      return $search;
   }
}
